/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import lotr.common.LOTRCreativeTabs;
import lotr.common.block.BlockPos;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ScaffoldingBlock
extends Block {
    private static final ForgeDirection[] direction = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    protected double field_149759_B = 0.01;
    protected double field_149754_D = 0.01;
    protected double field_149755_E = 0.99;
    protected double field_149757_G = 0.99;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottom;

    public ScaffoldingBlock() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149647_a(LOTRCreativeTabs.tabUtil);
        this.func_149672_a(field_149766_f);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (world.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
            return true;
        }
        for (ForgeDirection d : direction) {
            BlockPos blockPos = new BlockPos(x, y, z, d);
            for (int i = 0; i < 6; ++i) {
                blockPos.moveForwards(1);
                if (!world.func_147439_a(blockPos.x, blockPos.y, blockPos.z).equals((Object)this) || !world.isSideSolid(blockPos.x, blockPos.y - 1, blockPos.z, ForgeDirection.UP)) {
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return this.func_149718_j(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    public IIcon func_149691_a(int side, int meta) {
        return side == 0 ? this.iconBottom : (side == 1 ? this.iconTop : this.field_149761_L);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.UP || side == ForgeDirection.DOWN;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float xOffset, float yOffset, float zOffset) {
        ItemStack item = player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c];
        if (item != null && ScaffoldingBlock.func_149634_a((Item)item.func_77973_b()).equals((Object)this)) {
            int e = world.func_72940_L();
            for (int i = y + 1; i < e; ++i) {
                Block block = world.func_147439_a(x, i, z);
                if (block == null || world.func_147437_c(x, i, z) || block.isReplaceable((IBlockAccess)world, x, i, z)) {
                    if (!world.field_72995_K && world.func_147465_d(x, i, z, (Block)this, 0, 3)) {
                        world.func_72889_a(null, 2001, x, i, z, ScaffoldingBlock.func_149682_b((Block)this));
                        if (!player.field_71075_bZ.field_75098_d) {
                            ItemStack itemStack = item;
                            --itemStack.field_77994_a;
                            if (item.field_77994_a == 0) {
                                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                            }
                        }
                    }
                    return true;
                }
                if (block.equals((Object)this)) {
                    continue;
                }
                return false;
            }
        }
        return false;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity.field_70121_D.field_72338_b >= (double)((float)y + 0.9777778f) || entity.field_70121_D.field_72337_e <= (double)((float)y + 0.022222223f)) {
            return;
        }
        entity.field_70143_R = 0.0f;
        if (entity.field_70123_F) {
            entity.field_70181_x = 0.2;
        } else if (entity.func_70093_af()) {
            double diff = entity.field_70167_r - entity.field_70163_u;
            AxisAlignedBB boundingBox = entity.field_70121_D;
            boundingBox.field_72338_b += diff;
            AxisAlignedBB boundingBox2 = entity.field_70121_D;
            boundingBox2.field_72337_e += diff;
            entity.field_70163_u = entity.field_70167_r;
        } else {
            entity.field_70181_x = -0.12;
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            for (ForgeDirection direction : ScaffoldingBlock.direction) {
                int sideX = x + direction.offsetX;
                int sideZ = z + direction.offsetZ;
                Block sideBlock = world.func_147439_a(sideX, y, sideZ);
                if (!sideBlock.func_149662_c()) continue;
                return;
            }
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    Block blockAtSide = world.func_147439_a(x + dx, y, z + dz);
                    if (!blockAtSide.equals((Object)this)) continue;
                    world.func_147468_f(x + dx, y, z + dz);
                }
            }
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(this.func_149641_N() + "_side");
        this.iconTop = iconRegister.func_94245_a(this.func_149641_N() + "_top");
        this.iconBottom = iconRegister.func_94245_a(this.func_149641_N() + "_top");
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return !world.func_147439_a(x, y, z).func_149662_c();
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.func_149695_a(world, x, y, z, null);
    }
}

